<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['to']) && isset($data['enquiry_id']) && isset($data['subject']) && isset($data['body']) && isset($data['type'])) {
            $toUser = $data['to'];
            $subject = $data['subject'];
            $body = $data['body'];
            $enquiry_id = $data['enquiry_id'];
            $type_of = $data['type'];
            $user_id = $data['user_id'];

            $sql = "INSERT INTO complaint_bd 
            (
            enquiry_id, 
            to_user, 
            email_subject, 
            email_body,
            type_of,
            status_request) 
            VALUES (
            :enquiry_id, 
            :to_user, 
            :email_subject, 
            :email_body, 
            :type_of,
            'Mail sent to relvent person/ department')";
            // Prepare statement
            $stmt = $conn->prepare($sql);

            $stmt->bindParam(':enquiry_id', $enquiry_id);
            $stmt->bindParam(':to_user', $toUser);
            $stmt->bindParam(':email_subject', $subject);
            $stmt->bindParam(':email_body', $body);
            $stmt->bindParam(':type_of', $type_of);

            // Execute the query
            if (!sendMail("$toUser", "$subject", "$body", "$user_id")) {
                throw new Exception("Mail Unsuccessfull");
            }

            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("All mandatory fields are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
