<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    try {
        $input = file_get_contents("php://input");

        $data = json_decode($input, true);

        if (($data['id']) && isset($data['product_name']) && isset($data['details'])) {
            $id = $data['id'];
            $product_name = $data['product_name'];
            $details = $data['details'];
            $price = $data['price'];
            $supplier = $data['supplier'];

            // Prepare SQL query
            $sql = "UPDATE products SET product_name = :product_name, details = :details, price = :price, supplier = :supplier WHERE id = :id";
            $stmt = $conn->prepare($sql);

            // Bind parameters
            $stmt->bindParam(':product_name', $product_name);
            $stmt->bindParam(':details', $details);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->bindParam(':price', $price);
            $stmt->bindParam(':supplier', $supplier);
            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "Record updated successfully"
                ];
            } else {
                throw new Exception("Failed to update record");
            }
        } else {
            throw new Exception("ID and all fields are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
