<?php
include '../../../config.php';

function assignEnquiry($enquiryId, $userId, $conn)
{
    $status = 1; // Storing as 'Active'

    // Deactivate previous assignments
    $sql = "UPDATE assign_enquiries SET status = 0 WHERE enquiry_id = :enquiry_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':enquiry_id', $enquiryId, PDO::PARAM_INT);
    $stmt->execute();

    // Insert new assignment
    $sql = "INSERT INTO assign_enquiries (user_id, enquiry_id, status, date) VALUES (:user_id, :enquiry_id, :status, NOW())";
    $stmt = $conn->prepare($sql);

    // Bind parameters
    $stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
    $stmt->bindParam(':enquiry_id', $enquiryId, PDO::PARAM_INT);
    $stmt->bindParam(':status', $status, PDO::PARAM_INT);

    // Execute the query
    if ($stmt->execute()) {
        return true;
    } else {
        throw new Exception("Failed to assign enquiry.");
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Check required fields
        if (!isset($_POST['cat_one_id'], $_POST['office_id'], $_POST['user_id'])) {
            throw new Exception("Missing required fields: cat_one_id, office_id, or user_id");
        }

        // Retrieve fields
        $fields = [
            'enquiry_by',
            'enquiry_entered_by',
            'income_range',
            'enquiry_date',
            'username',
            'cnic',
            'date_of_birth',
            'email',
            'father_name',
            'gender',
            'landline',
            'project',
            'product',
            'developer',
            'price_offered',
            'property_address',
            'source_of_information',
            'enquiry_status',
            'remarks',
            'office_id',
            'cat_one_id',
            'cat_two_id',
            'cat_three_id',
            'cat_four_id',
            'matured',
            'image',
            'city',
            'present_address',
            'permanent_address',
            'mobile_no_one',
            'mobile_no_two'
        ];

        $customFields = [
            'field_one',
            'field_two',
            'field_three',
            'field_four',
            'field_five',
            'field_six',
            'field_seven',
            'field_eight',
            'field_nine',
            'field_ten',
            'field_eleven',
            'field_twelve',
            'field_thirteen',
            'field_fourteen',
            'field_fifteen',
            'field_sixteen',
            'field_seventeen',
            'field_eighteen',
            'field_nineteen',
            'field_twenty'
        ];

        $data = [];
        foreach (array_merge($fields, $customFields) as $field) {
            $data[$field] = $_POST[$field] ?? null;
        }

        $data['matured'] = isset($_POST['matured']) ? 1 : 0;

        $unique_number = $conn->query("SELECT unique_number FROM organization LIMIT 1");
        $unique_number = $unique_number->fetch(PDO::FETCH_ASSOC)['unique_number'];

        if($unique_number == 1){   
            $stmt = $conn->prepare("SELECT mobile_no_one FROM enquiries WHERE mobile_no_one = :mobile_no_one LIMIT 1");
            $stmt->bindParam(':mobile_no_one', $_POST['mobile_no_one'], PDO::PARAM_STR);
            $stmt->execute();
            
            if($stmt->rowCount() > 0){
                throw new Exception("Contact Number already exists in system");
            }
        }

        $status = $conn->query("SELECT title FROM config_lead_stages WHERE set_initial = 1 LIMIT 1");
        $status = $status->fetch(PDO::FETCH_ASSOC)['title'] ?? '';
    

        // Prepare SQL query for enquiries
        $stmt = $conn->prepare("
            INSERT INTO enquiries (
                enquiry_by, enquiry_entered_by, income_range, enquiry_date, username, cnic, date_of_birth, 
                email, father_name, gender, landline, project, product, developer, price_offered, property_address, 
                source_of_information, enquiry_status, remarks, 
                field_one, field_two, field_three, field_four, field_five, field_six, field_seven, field_eight, 
                field_nine, field_ten, field_eleven, field_twelve, field_thirteen, field_fourteen, 
                field_fifteen, field_sixteen, field_seventeen, field_eighteen, field_nineteen, field_twenty,
                office_id, cat_one_id, cat_two_id, cat_three_id, cat_four_id, matured, enquiry_status_steps, image, city
                , present_address, permanent_address, mobile_no_one, mobile_no_two
            ) VALUES (
                :enquiry_by, :enquiry_entered_by, :income_range, :enquiry_date, :username, :cnic, :date_of_birth, 
                :email, :father_name, :gender, :landline, :project, :product, :developer, :price_offered, :property_address, 
                :source_of_information, :enquiry_status, :remarks, 
                :field_one, :field_two, :field_three, :field_four, :field_five, :field_six, :field_seven, :field_eight, 
                :field_nine, :field_ten, :field_eleven, :field_twelve, :field_thirteen, :field_fourteen, 
                :field_fifteen, :field_sixteen, :field_seventeen, :field_eighteen, :field_nineteen, :field_twenty,
                :office_id, :cat_one_id, :cat_two_id, :cat_three_id, :cat_four_id, :matured, '$status', :image, :city
                ,:present_address, :permanent_address, :mobile_no_one, :mobile_no_two
            )
        ");

        foreach ($data as $field => $value) {
            $stmt->bindValue(":$field", $value);
        }

        // Execute enquiry insert query
        if (!$stmt->execute()) {
            throw new Exception("Error inserting enquiry.");
        }

        // Get the last inserted enquiry ID
        $enquiry_id = $conn->lastInsertId();

        // Assign enquiry to the user
        assignEnquiry($enquiry_id, $_POST['user_id'], $conn);

        // Handle dynamically named image uploads
        $uploadDir = '../../../Uploads/';
        $imageStmt = $conn->prepare("
            INSERT INTO enquiry_images (image_path, enquiry_id, title) 
            VALUES (:image_path, :enquiry_id, :title)
        ");

        foreach ($_FILES as $key => $file) {
            if (strpos($key, 'images_') === 0 && isset($file['tmp_name']) && $file['error'] === UPLOAD_ERR_OK) {
                $imageIndex = str_replace('images_', '', $key);
                $imageName = $_POST["images_{$imageIndex}_name"] ?? null;

                $tmpName = $file['tmp_name'];
                $fileName = uniqid() . "_" . basename($file['name']);
                $imagePath = $uploadDir . $fileName;

                if (move_uploaded_file($tmpName, $imagePath)) {
                    $imageStmt->bindValue(':image_path', $fileName);
                    $imageStmt->bindValue(':enquiry_id', $enquiry_id, PDO::PARAM_INT);
                    $imageStmt->bindValue(':title', $imageName);
                    $imageStmt->execute();
                } else {
                    throw new Exception("Failed to upload image: {$file['name']}");
                }
            }
        }

        $response = [
            "success" => true,
            "message" => "Enquiry and images saved successfully."
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
}
