<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['id']) && isset($data['quantity']) && isset($data['date'])) {
            $product_id = $data['id'];
            $quantity = $data['quantity'];
            $date_recevings = $data['date'];
            // Prepare SQL query
            $sql = "INSERT INTO product_recevings (product_id, quantity, date_recevings) VALUES (:product_id, :quantity, :date_recevings)";
            $stmt = $conn->prepare($sql);

            // Bind parameters
            $stmt->bindParam(':product_id', $product_id);
            $stmt->bindParam(':quantity', $quantity);
            $stmt->bindParam(':date_recevings', $date_recevings);

            // Execute the query
            if ($stmt->execute()) {
                $updateInventorySql = "UPDATE products SET quantity = quantity + $quantity WHERE id = $product_id";
                $updateInventorySqlatmt = $conn->prepare($updateInventorySql);
                $updateInventorySqlatmt->execute();

                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("Missing Fields");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
