<?php

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Get the data from the POST request
        $data = json_decode(file_get_contents("php://input"), true);

        // Check if data is received correctly
        if ($data === null) {
            throw new Exception("Invalid JSON data received");
        }

        // Ensure the required fields are provided
        if (!isset($data['user_id']) || !isset($data['enquiry_id']) || !isset($data['status']) || !isset($data['id'])) {
            throw new Exception("Required fields missing");
        }

        $userId = $data['user_id'];
        $enquiryId = $data['enquiry_id'];
        $status = $data['status'];
        $id = $data['id'];

        // Initialize the SQL query
        $sql = "UPDATE assign_enquiries SET user_id = :user_id, enquiry_id = :enquiry_id, status = :status WHERE id = :id";
        $stmt = $conn->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':user_id', $userId);
        $stmt->bindParam(':enquiry_id', $enquiryId);
        $stmt->bindParam(':status', $status);
        $stmt->bindParam(':id', $id);

        // Execute the query
        if ($stmt->execute()) {
            $response = [
                "success" => true,
                "message" => "Record updated successfully"
            ];
        } else {
            throw new Exception("No record updated");
        }
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
