<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $query = "SELECT enquiries.*,  
                            office.name AS office_name, 
                            category_level_one.name AS cat_one_name, 
                            category_level_two.name AS cat_two_name, 
                            category_level_three.name AS cat_three_name, 
                            category_level_four.name AS cat_four_name 
                    FROM enquiries 
                    LEFT JOIN office ON enquiries.office_id = office.id
                    LEFT JOIN category_level_one ON enquiries.cat_one_id = category_level_one.id
                    LEFT JOIN category_level_two ON enquiries.cat_two_id = category_level_two.id
                    LEFT JOIN category_level_three ON enquiries.cat_three_id = category_level_three.id
                    LEFT JOIN category_level_four ON enquiries.cat_four_id = category_level_four.id
                    WHERE 1=1";

                    $countQuery = "SELECT COUNT(*) AS total_count 
                    FROM enquiries 
                    LEFT JOIN office ON enquiries.office_id = office.id
                    LEFT JOIN category_level_one ON enquiries.cat_one_id = category_level_one.id
                    LEFT JOIN category_level_two ON enquiries.cat_two_id = category_level_two.id
                    LEFT JOIN category_level_three ON enquiries.cat_three_id = category_level_three.id
                    LEFT JOIN category_level_four ON enquiries.cat_four_id = category_level_four.id
                    WHERE 1=1";

        $params = [];
        $countParams = [];
        // Pagination Parameters
        $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
        $limit = 10; // Always return 10 records per page
        $offset = ($page - 1) * $limit; // Correct offset calculation


        // Check if an ID parameter is provided
        if (isset($_GET['id'])) {
            $query .= " AND enquiries.id = ?"; 
            $countQuery .= " AND enquiries.id = ?";
            $params[] = $_GET['id'];  
        } 

        if (isset($_GET['user_id']) && $_GET['user_id'] != 'Unassigned') {
            $query .= " AND enquiries.id IN (SELECT enquiry_id FROM assign_enquiries WHERE user_id = ? AND status = 1)";
            $countQuery .= " AND enquiries.id IN (SELECT enquiry_id FROM assign_enquiries WHERE user_id = ? AND status = 1)";
            $params[] = $_GET['user_id']; 
        } 

        if (isset($_GET['user_id']) && $_GET['user_id'] == 'Unassigned') {
            $query .= " AND enquiries.id NOT IN (SELECT enquiry_id FROM assign_enquiries)";
            $countQuery .= " AND enquiries.id NOT IN (SELECT enquiry_id FROM assign_enquiries)";
        } 

        // Check for date range
        if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
            $query .= " AND DATE(created_at) BETWEEN ? AND ?";
            $countQuery .= " AND DATE(created_at) BETWEEN ? AND ?";
            $params[':start_date'] = $start_date;
            $params[':end_date'] = $end_date;
        }

        if (isset($_GET['status'])) {
            $query .= " AND enquiries.status = ?";
            $countQuery .= " AND enquiries.status = ?";
            $params[] = $_GET['status']; 
        }

        $query .= " ORDER BY enquiries.created_at ASC"; 


        // Apply Pagination

        $query .= " LIMIT $limit OFFSET $offset";


        // Prepare and execute the statement
        $stmt = $conn->prepare($query);
        $stmt->execute($params);

        $count_query_stmt = $conn->prepare($countQuery);
        $count_query_stmt->execute($params);
       // var_dump($count_query_stmt);
        // Fetch all records or a single record
        $results = isset($id) ? [$stmt->fetch(PDO::FETCH_ASSOC)] : $stmt->fetchAll(PDO::FETCH_ASSOC);

        $count_query_stmt_res = $count_query_stmt->fetch(PDO::FETCH_ASSOC);


        // Fetch field mappings with status 1
        $fieldStmt = $conn->prepare("SELECT field_name, title, order_no, type FROM enquiry_fields WHERE status = 1 ORDER BY order_no");
        $fieldStmt->execute();
        $fields = $fieldStmt->fetchAll(PDO::FETCH_ASSOC);

        if ($id) {
            $pStmt = $conn->prepare("SELECT * FROM enquiry_products ep INNER JOIN products p ON ep.product_id = p.id WHERE ep.enquiry_id = :id");
            $pStmt->execute([':id' => $id]);
            $pStmt = $pStmt->fetchAll(PDO::FETCH_ASSOC);
        }

        // Create a mapping of field names to titles
        $fieldMapping = [];
        foreach ($fields as $field) {
            $fieldMapping[$field['field_name']] = [
                'title' => $field['title'],
                'order_no' => $field['order_no'],
                'type' => $field['type']
            ];
        }

        // Define the required IDs
        $requiredIDs = ['office_name', 'cat_one_name', 'cat_two_name', 'cat_three_name', 'cat_four_name', 'status', 'enquiry_status_steps'];

        $responseData = [];
        foreach ($results as $index => $result) {
            $sr_no = $offset + $index + 1; 
            $dataWithTitles = [];
            $processedKeys = [];

            foreach ($result as $key => $value) {
                // Include the required IDs explicitly
                if (isset($fieldMapping[$key]) || in_array($key, $requiredIDs)) {
                    $title = isset($fieldMapping[$key]) ? $fieldMapping[$key]['title'] : ucfirst(str_replace('_', ' ', $key));
                    $order_no = isset($fieldMapping[$key]) ? $fieldMapping[$key]['order_no'] : null;
                    $type = isset($fieldMapping[$key]) ? $fieldMapping[$key]['type'] : null;

                    $dataWithTitles[] = [
                        "field_name" => $key,
                        "title" => $title,
                        "value" => $value,
                        "order_no" => $order_no,
                        "type" => $type // Add order_no to the response
                    ];
                    $processedKeys[] = $key;
                }
            }

            // Ensure all required IDs are included even if they are null
            foreach ($requiredIDs as $requiredID) {
                if (!in_array($requiredID, $processedKeys)) {
                    $dataWithTitles[] = [
                        "field_name" => $requiredID,
                        "title" => ucfirst(str_replace('_', ' ', $requiredID)),
                        "value" => null,
                        "order_no" => null, // Assign null if order_no is not applicable
                        "type" => null // Assign null if order_no is not applicable
                    ];
                }
            }

            // Sort $dataWithTitles array by order_no
            usort($dataWithTitles, function ($a, $b) {
                return $a['order_no'] <=> $b['order_no'];
            });

            if ($result['id']) {
                $pStmt = $conn->prepare("SELECT * FROM enquiry_products ep INNER JOIN products p ON ep.product_id = p.id WHERE ep.enquiry_id = :id");
                $pStmt->execute([':id' => $result['id']]);
                $pStmt = $pStmt->fetchAll(PDO::FETCH_ASSOC);
            }

            $e_status = $conn->prepare("SELECT enquiry_status_steps FROM enquiries WHERE id = :id");
            $e_status->execute([':id' => $result['id']]);
            $e_res = $e_status->fetchAll(PDO::FETCH_ASSOC);



            $imgStmt = $conn->prepare("SELECT * FROM enquiry_images WHERE enquiry_id = :id");
            $imgStmt->execute([':id' => $result['id']]);
            $imgStmt = $imgStmt->fetchAll(PDO::FETCH_ASSOC);



            $totalEntries = $count_query_stmt_res;

            
            $responseData[] = [
                "sr_no" => $sr_no,
                "id" => $result['id'],
                "fields" => $dataWithTitles,
                "products" => $pStmt, 
                "status" => $e_res,
                "images" => $imgStmt
            ];
        }

        // Final response (with pagination)

        
        if (isset($id)) {
            $response = [
                "success" => true,
                "data" => $responseData[0]
                 // Return a single record if ID is provided
            ];
        } else {
            $response = [
                "success" => true,
                "data" => $responseData,
                
                "pagination" => [
                    "current_page" => $page,
                    "per_page" => 10,
                    "total_entries" => $totalEntries['total_count'],
                    "total_pages" => ceil($totalEntries['total_count'] / 10)
                ]
            ];
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([  
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
