<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['product_id']) && isset($data['start_range']) && isset($data['unit_price'])) {
            $product_id = $data['product_id'] ?? null;
            $id = $data['id'] ?? null;
            $start_range = $data['start_range'];
            $end_range = $data['end_range'] ?? null; // Default to null if not provided
            $unit_price = $data['unit_price'];
            $unit = $data['unit'] ?? null; // Default to null if not provided
            $additional_amount = $data['additional_amount'] ?? 0; // Default to 0 if not provided

            if ($data['edit'] === 'new') {
                // Prepare SQL query for insertion
                $sql = "INSERT INTO product_service_charges 
                        (range_start, range_end, unit_price, product_id, unit, additional_amount) 
                        VALUES (:range_start, :range_end, :unit_price, :product_id, :unit, :additional_amount)";
            } else {
                // Prepare SQL query for update
                $sql = "UPDATE product_service_charges 
                        SET range_start = :range_start, 
                            range_end = :range_end, 
                            unit_price = :unit_price, 
                            unit = :unit, 
                            additional_amount = :additional_amount 
                        WHERE id = $id";
            }

            $stmt = $conn->prepare($sql);

            // Bind parameters
            if ($data['edit'] === 'new') {
            $stmt->bindParam(':product_id', $product_id);
            }
            $stmt->bindParam(':range_start', $start_range);
            $stmt->bindParam(':range_end', $end_range);
            $stmt->bindParam(':unit_price', $unit_price);
            $stmt->bindParam(':unit', $unit);
            $stmt->bindParam(':additional_amount', $additional_amount);
        
            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => ($data['edit'] === 'new') ? "Record created successfully" : "Record updated successfully"
                ];
            } else {
                throw new Exception("Failed to execute query");
            }
        } else {
            throw new Exception("Missing required fields");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
?>
