<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Prepare SQL query to fetch all products
        $sql = "SELECT * FROM products";
        $stmt = $conn->prepare($sql);

        // Execute the query
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Initialize an array to hold the combined data
            $products_with_quot_quantity = [];

            foreach ($result as $res) {
                // Fetch the quotations quantity for each product
                $sql_quot = "
                    SELECT SUM(quantity) as quot_quantity 
                    FROM quotations_items 
                    INNER JOIN quotations ON quotations_items.quotations_id = quotations.id
                    WHERE quantity IS NOT NULL 
                    AND quotations.status IS NULL
                    AND product_id = :product_id
                    GROUP BY product_id
                ";
                $quot_stmt = $conn->prepare($sql_quot);
                $quot_stmt->bindParam(':product_id', $res['id'], PDO::PARAM_INT);
                $quot_stmt->execute();
                $quot_result = $quot_stmt->fetch(PDO::FETCH_ASSOC);

                // Add quotations quantity to the product data
                $res['quot_quantity'] = $quot_result['quot_quantity'] ?? 0; // Default to 0 if null
                $products_with_quot_quantity[] = $res;
            }

            // Prepare the successful response
            $response = [
                "success" => true,
                "data" => $products_with_quot_quantity
            ];
        } else {
            throw new Exception("Failed to retrieve records");
        }
    } catch (PDOException $e) {
        // Handle database errors
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        // Handle other errors
        $response = [
            "success" => false,
            "message" => "An error occurred",
            "error_details" => $e->getMessage()
        ];
    }

    // Return the JSON response
    echo json_encode($response);
} else {
    // Handle non-GET requests
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
