<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Get the data from the POST request
        $data = json_decode(file_get_contents("php://input"), true);

        // Check if data is received correctly
        if ($data === null) {
            throw new Exception("Invalid JSON data received");
        }

        // Ensure the 'id' and 'password' fields are provided for identifying the record and updating the password
        if (!isset($data['id']) || !isset($data['password'])) {
            throw new Exception("ID or password missing");
        }

        $id = intval($data['id']);
        $password = $data['password'];

        // Hash the password before storing it
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        // Prepare the SQL query to update the password
        $sql = "UPDATE users SET password = :password WHERE id = :id";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':password', $hashedPassword, PDO::PARAM_STR);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        // Execute the query
        if ($stmt->execute()) {
            $response = [
                "success" => true,
                "message" => "Password updated successfully"
            ];
        } else {
            throw new Exception("Failed to update the password");
        }
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
