<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

        // Helper function to generate SQL for a specific interval
        function generateSQL($interval, $user_id) {
            $sql = "SELECT 
                        IFNULL(called_status, 'N/A') AS called_status,
                        COUNT(called_status) as total
                    FROM 
                        follow_up
                    WHERE 
                        followup_date >= DATE_SUB(NOW(), INTERVAL $interval DAY)
                        AND followup_date < CURDATE()
                        AND followup_date IS NOT NULL
                        AND id IN (SELECT MAX(id) FROM follow_up GROUP BY enquiry_id) ";

            // Add user_id condition if provided
            if ($user_id) {
                $sql .= "AND user_id = :uid ";
            }

            $sql .= "GROUP BY called_status";
            return $sql;
        }

        // Prepare SQL queries for each interval
        $intervals = [7, 30, 60, 90, 180];
        $data = [];

        foreach ($intervals as $interval) {
            $sql = generateSQL($interval, $user_id);
            $stmt = $conn->prepare($sql);

            // Bind parameters if user_id is provided
            if ($user_id) {
                $stmt->bindParam(':uid', $user_id, PDO::PARAM_INT);
            }

            // Execute the statement and fetch data
            $stmt->execute();
            $data["last_{$interval}_days"] = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }

        // Combine all data into the response
        $response = [
            "success" => true,
            "data" => $data
        ];
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred.",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "An unexpected error occurred.",
            "error_details" => $e->getMessage()
        ];
    }

    // Output the JSON response
    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method. Only GET is allowed."
    ]);
}
?>
