<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {


        if (!isset($_GET['user_id'], $_GET['start_date'], $_GET['end_date'])) {
            throw new Exception("Params Missing");
        }

        $sql = "SELECT 
            SUM(CASE WHEN called_status = 'Call Disconnected' THEN 1 ELSE 0 END) AS call_disconnected,
            SUM(CASE WHEN follow_up_status = 'Not Attended' THEN 1 ELSE 0 END) AS phn_not_picked,
            SUM(CASE WHEN called_status = 'Wrong Number' THEN 1 ELSE 0 END) AS wrong_number,
            COUNT(*) AS total_calls
        FROM follow_up WHERE follow_up_type = 'Call'
        AND DATE(followup_date) 
            BETWEEN DATE('$_GET[start_date]') AND DATE('$_GET[end_date]') 
        AND user_id = $_GET[user_id];";


        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $kpis = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($kpis) > 0) {
            $response = [
                "success" => true,
                "data" => $kpis
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
