<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        // Check if ID is provided
        if (!isset($data['id'])) {
            throw new Exception("ID is required");
        }

        $id = $data['id'];
        $product = $data['product'];
        unset($data['id']);

        $success = true;
        foreach ($data as $key => $value) {
            // Prepare the SQL query using prepared statements to prevent SQL injection
            $stmt = $conn->prepare("UPDATE enquiries SET $key = :value WHERE id = :id");
            $stmt->bindParam(':value', $value);
            $stmt->bindParam(':id', $id);

            if (!$stmt->execute()) {
                $success = false;
                break;
            }
        }

        $stmt = $conn->prepare("DELETE FROM enquiry_products WHERE enquiry_id = $id");
        $stmt->execute();

        foreach ($product as $key => $value) {
            // Prepare the SQL query using prepared statements to prevent SQL injection

            $stmt = $conn->prepare("INSERT INTO enquiry_products (enquiry_id, product_id) VALUES ($id, :pId)");
            $stmt->bindParam(':pId', $value);

            if (!$stmt->execute()) {
                $success = false;
                break;
            }
        }

        // Execute the statement
        if ($success) {
            $response = [
                "success" => true,
                "message" => "Record updated successfully"
            ];
        } else {
            throw new Exception("Error executing query.");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
