<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Prepare SQL query
        $sql = "SELECT ck.* FROM config_kpis ck";
        $stmt = $conn->prepare($sql);

        // Execute the query
        $data = [];
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

            foreach ($result as $key => $value) {
                $role_weight_sql = "SELECT weight FROM config_kpis_role WHERE kpi_id = :kpi_id AND role_id = :role_id LIMIT 1";
                $role_weight_stmt = $conn->prepare($role_weight_sql);
                $role_weight_stmt->bindParam(':kpi_id', $value['id'], PDO::PARAM_INT);
                $role_weight_stmt->bindParam(':role_id', $_GET['id'], PDO::PARAM_INT);
                $role_weight_stmt->execute();
                $role_weight = $role_weight_stmt->fetch(PDO::FETCH_ASSOC);

                // Add weight to the current KPI result
                $value['weight'] = $role_weight['weight'] ?? 0; // Use null if no weight is found
                $data[] = $value;
            }

            $response = [
                "success" => true,
                "data" => $data
            ];
        } else {
            throw new Exception("Failed to retrieve records");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
