<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        // Validate required fields
        if (isset($data['user_id'], $data['enquiries']) && is_array($data['enquiries'])) {
            $userId = $data['user_id'];
            $date = $data['date'];
            $type = $data['type'];
            $enquiryIds = $data['enquiries']; // Array of enquiry IDs
            $status = 1; // Active status

            // Start a transaction
            $conn->beginTransaction();

            foreach ($enquiryIds as $enquiryId) {
                // Update previous assignments for this enquiry to inactive
                $updateSql = "UPDATE assign_enquiries SET status = 0 WHERE enquiry_id = :enquiry_id";
                $updateStmt = $conn->prepare($updateSql);
                $updateStmt->bindParam(':enquiry_id', $enquiryId, PDO::PARAM_INT);
                $updateStmt->execute();

                $first_tim_data = "INSERT INTO first_time_assignment (date, type, enquiry_id) values ('$date', '$type', $enquiryId)";
                $first_tim_data = $conn->prepare($first_tim_data);
                $first_tim_data->execute();

                // Insert new assignment
                $insertSql = "
                    INSERT INTO assign_enquiries (user_id, enquiry_id, status, date) 
                    VALUES (:user_id, :enquiry_id, :status, NOW())
                ";
                $insertStmt = $conn->prepare($insertSql);
                $insertStmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
                $insertStmt->bindParam(':enquiry_id', $enquiryId, PDO::PARAM_INT);
                $insertStmt->bindParam(':status', $status, PDO::PARAM_INT);
                $insertStmt->execute();
            }

            // Commit the transaction
            $conn->commit();

            $response = [
                "success" => true,
                "message" => "Enquiries assigned successfully"
            ];
        } else {
            throw new Exception("User ID and enquiries are required and enquiries should be an array");
        }
    } catch (PDOException $e) {
        // Rollback transaction on error
        if ($conn->inTransaction()) {
            $conn->rollBack();
        }
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Validation error",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
