<?php
header('Content-Type: application/json'); // Set header for JSON response

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        $title = isset($_GET['title']) ? $_GET['title'] : null;

        // Initialize the SQL query and parameters
        $sql = "SELECT id, title, field_name, CONVERT(status, UNSIGNED) AS status, type, show_field, required, report_show, order_no, disabled FROM enquiry_fields ORDER BY order_no";
        $params = [];


        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters
        foreach ($params as $key => $value) {
            $stmt->bindParam($key, $value);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $enquiry_fields = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Check if any records are found
        if (count($enquiry_fields) > 0) {
            foreach ($enquiry_fields as &$field) {
                // If the field type is dropdown, fetch the dropdown values
                $field['status'] = (int)$field['status'];
                
                if ($field['type'] === 'Drop Down') {
                    $dropdown_sql = "SELECT dropdown FROM enquiry_fields_dropdown WHERE field_name = :field_name";
                    $dropdown_stmt = $conn->prepare($dropdown_sql);
                    $dropdown_stmt->bindParam(':field_name', $field['field_name']);
                    $dropdown_stmt->execute();
                    $dropdown_values = $dropdown_stmt->fetchAll(PDO::FETCH_COLUMN);

                    // Attach dropdown values to the field
                    $field['dropdown_values'] = $dropdown_values;
                }
            }
            unset($field); // Unset reference to avoid issues later

            $response = [
                "data" => $enquiry_fields,
                "success" => true,
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
