<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['name']) && isset($data['organization_id'])) {

            $name = $data['name'];
            $organizationId = $data['organization_id'];
            $quot_inactive_days = $data['quot_inactive_days'];
            $sender_mail = isset($data['sender_mail']) ? $data['sender_mail'] : null;
            $password = isset($data['password']) ? $data['password'] : null;
            $port = isset($data['port']) ? $data['port'] : null;
            $host = isset($data['host']) ? $data['host'] : null;

            // Prepare SQL query using prepared statements
            $stmt = $conn->prepare("INSERT INTO office (organization_id, name, sender_email, password, port, host, quot_inactive_days) VALUES (:organization_id, :name, :sender_mail, :password, :port, :host, :quot_inactive_days)");

            // Bind parameters
            $stmt->bindParam(':organization_id', $organizationId, PDO::PARAM_INT);
            $stmt->bindParam(':quot_inactive_days', $quot_inactive_days, PDO::PARAM_INT);
            $stmt->bindParam(':name', $name, PDO::PARAM_STR);
            $stmt->bindParam(':sender_mail', $sender_mail, PDO::PARAM_STR);
            $stmt->bindParam(':password', $password, PDO::PARAM_STR);
            $stmt->bindParam(':port', $port, PDO::PARAM_INT);
            $stmt->bindParam(':host', $host, PDO::PARAM_STR);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("Name and organization ID are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
