<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $role_id = $_GET['role_id'] ?? null;
        $data = json_decode(file_get_contents("php://input"), true);

        if ($role_id !== null) {
            $sql = "SELECT * FROM permissions WHERE role_id = :role_id";
            $stmt_prep = $conn->prepare($sql);
            $stmt_prep->bindParam(':role_id', $role_id, PDO::PARAM_INT);
            $stmt_prep->execute();
            $permissions = $stmt_prep->fetchAll(PDO::FETCH_ASSOC);

            if (count($permissions) > 0) {
                foreach ($data as $x => $y) {
                    if ($x !== 'role_id') {  // Ensure role_id is not updated
                        $stmt = $conn->prepare("UPDATE permissions SET $x = :value WHERE role_id = :role_id");
                        $stmt->bindValue(':value', ($y == null || $y == false ? 0 : 1), PDO::PARAM_INT);
                        $stmt->bindParam(':role_id', $role_id, PDO::PARAM_INT);
                        $stmt->execute();
                    }
                }
                $response = [
                    "success" => true,
                    "message" => "Record updated successfully"
                ];
            } else {
                // Prepare the column names and named placeholders for the INSERT query
                $columns = implode(", ", array_keys($data));
                $placeholders = implode(", ", array_map(function($key) { return ":$key"; }, array_keys($data)));

                // Prepare the INSERT query
                $stmt = $conn->prepare("INSERT INTO permissions (role_id, $columns) VALUES (:role_id, $placeholders)");

                // Bind the role_id
                $stmt->bindParam(':role_id', $role_id, PDO::PARAM_INT);

                // Bind each value from $data using named parameters
                foreach ($data as $key => $value) {
                    $stmt->bindValue(":$key", ($value == null || $value == false ? 0 : 1), PDO::PARAM_INT);
                }

                // Execute the query
                $stmt->execute();

                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            }
        } else {
            throw new Exception("Role ID is required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Fields Missing",
            "error" => $e->getMessage()
        ];
    } catch (Exception $e) {
          $response = [
            "success" => false,
            "message" => "Fields Missing",
            "error" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
