<?php
header('Content-Type: application/json'); // Set header for JSON response
include '../../config.php'; // Include the config file

function getFollowUpReq($conn, $enquiry, $start_date, $agents, $types)
{
    // Fetch follow-ups for each enquiry
    $follow_up_sql = "SELECT follow_up.*, users.username 
     FROM follow_up 
     INNER JOIN users ON follow_up.user_id = users.id 
     WHERE follow_up.enquiry_id = ?";

    $params = [$enquiry['id']];

    // Add agent filter if specific agents are provided
    if (!empty($agents) && !in_array('All', $agents)) {
        $placeholders = implode(',', array_fill(0, count($agents), '?'));
        $follow_up_sql .= " AND follow_up.user_id IN ($placeholders)";
        $params = array_merge($params, $agents);
    }

    // Add date filter
    if ($start_date !== null) {
        $follow_up_sql .= " AND DATE(follow_up.next_followup_date) = DATE(?)";
        $params[] = $start_date;
    }

    // Add type filter if specific types are provided
    if (!empty($types) && !in_array('All', $types)) {
        $placeholders = implode(',', array_fill(0, count($types), '?'));
        $follow_up_sql .= " AND follow_up.follow_up_type IN ($placeholders)";
        $params = array_merge($params, $types);
    }

    $follow_up_sql .= " ORDER BY DATE(follow_up.followup_date) DESC";

    $stmt_follow_up = $conn->prepare($follow_up_sql);
    $stmt_follow_up->execute($params);
    return $stmt_follow_up->fetchAll(PDO::FETCH_ASSOC);
}


function getFollowUpDone($conn, $enquiry, $start_date, $agents, $types)
{
    // Fetch follow-ups for each enquiry
    $follow_up_sql = "SELECT follow_up.*, users.username 
     FROM follow_up 
     INNER JOIN users ON follow_up.user_id = users.id 
     WHERE follow_up.enquiry_id = ?";

    $params = [$enquiry['id']];

    // Add agent filter if specific agents are provided
    if (!empty($agents) && !in_array('All', $agents)) {
        $placeholders = implode(',', array_fill(0, count($agents), '?'));
        $follow_up_sql .= " AND follow_up.user_id IN ($placeholders)";
        $params = array_merge($params, $agents);
    }

    // Add date filter
    if ($start_date !== null) {
        $follow_up_sql .= " AND DATE(follow_up.followup_date) = DATE(?)";
        $params[] = $start_date;
    }

    // Add type filter if specific types are provided
    if (!empty($types) && !in_array('All', $types)) {
        $placeholders = implode(',', array_fill(0, count($types), '?'));
        $follow_up_sql .= " AND follow_up.follow_up_type IN ($placeholders)";
        $params = array_merge($params, $types);
    }

    $follow_up_sql .= " ORDER BY DATE(follow_up.followup_date) DESC";

    $stmt_follow_up = $conn->prepare($follow_up_sql);
    $stmt_follow_up->execute($params);
    return $stmt_follow_up->fetchAll(PDO::FETCH_ASSOC);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetch query parameters from the GET request
        $agents = isset($_GET['agent']) ? $_GET['agent'] : []; // Directly fetch as array
        $types = isset($_GET['type']) ? $_GET['type'] : []; // Directly fetch as array
        $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : null;
        $enq_start_date = isset($_GET['enq_start_date']) ? $_GET['enq_start_date'] : null;
        $enq_end_date = isset($_GET['enq_end_date']) ? $_GET['enq_end_date'] : null;

        // Fetch enquiries
        $enq_sql = "SELECT id, 
                            enquiry_by as generated_by,
                            username as full_name,
                            mobile_no_one as mobile_number    
                            FROM enquiries WHERE created_at BETWEEN DATE(?) AND DATE(?)";
        $stmt_enq = $conn->prepare($enq_sql);
        $stmt_enq->execute([$enq_start_date, $enq_end_date]);
        $enquiries = $stmt_enq->fetchAll(PDO::FETCH_ASSOC);

        foreach ($enquiries as &$enquiry) {
            $enquiry['follow_ups_req'] = getFollowUpReq($conn, $enquiry, $start_date, $agents, $types);
            $enquiry['follow_ups_done'] = getFollowUpDone($conn, $enquiry, $start_date, $agents, $types);
        }

        // Success response
        echo json_encode([
            "success" => true,
            "data" => $enquiries
        ]);
    } catch (PDOException $e) {
        echo json_encode([
            "success" => false,
            "message" => "Database error occurred.",
            "error_details" => $e->getMessage()
        ]);
    } catch (Exception $e) {
        echo json_encode([
            "success" => false,
            "message" => "An error occurred.",
            "error_details" => $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}
