<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['id'], $data['enquiry_id'])) {
            $quot_id = $data['id'];
            $enq_id = $data['enquiry_id'];

            // Prepare SQL query with placeholders
            $sql = "UPDATE quotations SET approval = 'Approved', is_sales_order = 1 WHERE id = :quot_id";
            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':quot_id', $quot_id, PDO::PARAM_INT);

            // Execute the query
            if ($stmt->execute()) {

                // Fetch matured status
                $STATUS_SQL = $conn->prepare("SELECT * FROM config_lead_stages WHERE matured_status");
                $STATUS_SQL->execute();
                $maturedStatuses = $STATUS_SQL->fetch(PDO::FETCH_ASSOC);

                if ($maturedStatuses) {
                    // Update enquiry status
                    $sql_enq = "UPDATE enquiries SET enquiry_status_steps = :status_title, enquiry_matured_date = NOW() WHERE id = :enq_id";
                    $sql_enq_stmt = $conn->prepare($sql_enq);
                    $sql_enq_stmt->bindParam(':status_title', $maturedStatuses['title'], PDO::PARAM_STR);
                    $sql_enq_stmt->bindParam(':enq_id', $enq_id, PDO::PARAM_INT);
                    $sql_enq_stmt->execute();
                }

                // Fetch items from quotations
                $sql_items = "SELECT json_data FROM quotations WHERE id = :quot_id";
                $sql_items_stmt = $conn->prepare($sql_items);
                $sql_items_stmt->bindParam(':quot_id', $quot_id, PDO::PARAM_INT);
                $sql_items_stmt->execute();
                $sql_items_data = $sql_items_stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($sql_items_data && !empty($sql_items_data['json_data'])) {
                    $sql_items_data = json_decode(json_decode($sql_items_data['json_data'], true), true);

                    if (!empty($sql_items_data['step_2'])) {
                        foreach ($sql_items_data['step_2'] as $key => $value) {
                            $sql_item = "UPDATE products SET quantity = quantity - :quantity WHERE product_name = :product_name";
                            $sql_item_stmt = $conn->prepare($sql_item);
                            $sql_item_stmt->bindParam(':quantity', $value['quantity'], PDO::PARAM_INT);
                            $sql_item_stmt->bindParam(':product_name', $value['name'], PDO::PARAM_STR);
                            $sql_item_stmt->execute();
                        }
                    }
                }

                $response = [
                    "success" => true,
                    "message" => "Approved Successfully"
                ];
            } else {
                throw new Exception("Not Approved");
            }
        } else {
            throw new Exception("Missing required parameters");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Error occurred",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
