<?php
header('Content-Type: application/json'); // Set header for JSON response

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        $role = isset($_GET['role']) ? $_GET['role'] : null;

        // Initialize the SQL query and parameters
        $sql = "SELECT * FROM roles";
        $params = [];

        if ($id) {
            $sql .= " WHERE id = :id";
            $params[':id'] = $id;
        } elseif ($role) {
            $sql .= " WHERE role = :role";
            $params[':role'] = $role;
        }

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters
        foreach ($params as $key => $value) {
            $stmt->bindParam($key, $value);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $roles = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($roles) > 0) {
            $response = [
                // "success" => true,
                "data" => $roles
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
