<?php
header('Content-Type: application/json'); // Set header for JSON response
include '../../config.php';

function convertUTCtoMySQL($utcDateString)
{
    if (empty($utcDateString)) {
        return null;
    }
    try {
        $date = new DateTime($utcDateString, new DateTimeZone('UTC'));
        return $date->format('Y-m-d H:i:s');
    } catch (Exception $e) {
        return null; // Graceful fallback for invalid dates
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        // Retrieve input data
        $id = $data['id'] ?? null; // Assuming the row ID to update is provided
        $follow_up_type = $data['follow_up_type'] ?? null;
        $follow_up_status = $data['follow_up_status'] ?? null;
        $next_follow_up_type = $data['next_follow_up_type'] ?? null;
        $called_type = $data['called_type'] ?? 0;
        $remarks = $data['remarks'] ?? null;
        $price_offered = $data['price_offered'] ?? null;
        $called_status = $data['called_status'] ?? null;
        $call_type = $data['call_type'] ?? null;
        $next_followup_date = isset($data['next_followup_date']) ? convertUTCtoMySQL($data['next_followup_date']) : null;

        if (!$id) {
            echo json_encode([
                "success" => false,
                "message" => "ID is required for updating the record."
            ]);
            exit;
        }

        // Update follow-up record
        $sql = "UPDATE follow_up SET 
                    follow_up_type = :follow_up_type, 
                    follow_up_status = :follow_up_status, 
                    next_follow_up_type = :next_follow_up_type, 
                    remarks = :remarks, 
                    price_offered = :price_offered, 
                    next_followup_date = :next_followup_date, 
                    called_type = :called_type, 
                    called_status = :called_status,
                    call_type = :call_type
                WHERE id = :id";

        $stmt = $conn->prepare($sql);

        // Bind parameters
        $stmt->execute([
            ':follow_up_type' => $follow_up_type,
            ':follow_up_status' => $follow_up_status,
            ':next_follow_up_type' => $next_follow_up_type,
            ':remarks' => $remarks,
            ':price_offered' => $price_offered,
            ':next_followup_date' => $next_followup_date,
            ':called_type' => $called_type,
            ':called_status' => $called_status,
            ':call_type' => $call_type,
            ':id' => $id,
        ]);

        // Success response
        echo json_encode([
            "success" => true,
            "message" => "Updated successfully."
        ]);
    } catch (PDOException $e) {
        echo json_encode([
            "success" => false,
            "message" => "An error occurred while updating the record.",
            "error" => $e->getMessage()
        ]);
    } catch (Exception $e) {
        echo json_encode([
            "success" => false,
            "message" => $e->getMessage(),
        ]);
    }
} else {
    // Invalid request method response
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}
