<?php
header('Content-Type: application/json');

include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['username']) && isset($data['password'])) {
            $username = strtolower($data['username']);
            $password = $data['password'];

            // Prepare SQL query to fetch user
            $sql = "SELECT 
                        users.id as user_id, 
                        users.username, 
                        users.password, 
                        users.full_name, 
                        roles.self_inquiries,
                        roles.role AS role_name, 
                        users.status,
                        permissions.*
                    FROM users 
                    JOIN roles ON users.role_id = roles.id
                    JOIN permissions ON roles.id = permissions.role_id
                    WHERE lower(users.username) = :username
                    ";
            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':username', $username);
            $stmt->execute();
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user['status'] != 1) {
                throw new Exception("User is inactive");
            }

            // Check if user exists and verify password
            if ($user && password_verify($password, $user['password'])) {
                // Password is correct
                $response = [
                    "success" => true,
                    "message" => "Login successful",
                    "user_id" => $user['user_id'],
                    "role" => $user['role_name'],
                    "username" => $user['username'],
                    "fullname" => $user['full_name'],
                    "self_inquiries" => $user['self_inquiries'],
                    "permissions" => $user,

                ];
            } else {
                // Invalid username or password
                throw new Exception("Invalid username or password");
            }
        } else {
            throw new Exception("Username and password are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Invalid username or password",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage(),
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid username or password",
        "error_details" => $e->getMessage()
    ]);
}
