<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $response;
        $data = json_decode(file_get_contents("php://input"), true);
        $query = "SELECT enquiries.*, 
                            office.name AS office_name, 
                            category_level_one.name AS cat_one_name, 
                            category_level_two.name AS cat_two_name, 
                            category_level_three.name AS cat_three_name, 
                            category_level_four.name AS cat_four_name 
                    FROM enquiries 
                    LEFT JOIN office ON enquiries.office_id = office.id
                    LEFT JOIN category_level_one ON enquiries.cat_one_id = category_level_one.id
                    LEFT JOIN category_level_two ON enquiries.cat_two_id = category_level_two.id
                    LEFT JOIN category_level_three ON enquiries.cat_three_id = category_level_three.id
                    LEFT JOIN category_level_four ON enquiries.cat_four_id = category_level_four.id
                    WHERE 1=1 ";

                    $countQuery = "SELECT COUNT(*) AS total_count 
                    FROM enquiries 
                    LEFT JOIN office ON enquiries.office_id = office.id
                    LEFT JOIN category_level_one ON enquiries.cat_one_id = category_level_one.id
                    LEFT JOIN category_level_two ON enquiries.cat_two_id = category_level_two.id
                    LEFT JOIN category_level_three ON enquiries.cat_three_id = category_level_three.id
                    LEFT JOIN category_level_four ON enquiries.cat_four_id = category_level_four.id
                    WHERE 1=1";

        $params = [];
        $countParams = [];
    

        $page = isset($data['page']) ? (int)$data['page'] : 1;
        $limit = isset($data['limit']) ? (int)$data['limit'] : 10;
        $offset = ($page - 1) * $limit;
        // Function to generate placeholders for the IN clause and bind values
        function prepareInClause($column, $data, &$query, &$params, &$countQuery)
        {
            if (isset($data[$column]) && is_array($data[$column])) {
                $values = $data[$column];
                $placeholders = implode(',', array_fill(0, count($values), '?'));
                $query .= " AND $column IN ($placeholders) ";
                $params = array_merge($params, $values);
                $countQuery .= " AND $column IN ($placeholders) ";
            } elseif (isset($data[$column])) {
                // Single value case
                $query .= " AND $column = ? ";
                $countQuery .= " AND $column = ? ";
                $params[] = $data[$column];
            }
        }
        

        // Apply IN conditions or equals conditions based on the input data
        if (isset($data['cat_one_id']) && count($data['cat_one_id']) > 0) {
            prepareInClause('cat_one_id', $data, $query, $params, $countQuery);
        }

        if (isset($data['cat_two_id']) && count($data['cat_two_id']) > 0) {
            prepareInClause('cat_two_id', $data, $query, $params, $countQuery);
        }

        if (isset($data['cat_three_id']) && count($data['cat_three_id']) > 0) {
            prepareInClause('cat_three_id', $data, $query, $params, $countQuery);
        }

        if (isset($data['cat_four_id']) && count($data['cat_four_id']) > 0) {
            prepareInClause('cat_four_id', $data, $query, $params, $countQuery);
        }

        // Check for date range
        if (isset($data['start_date']) && isset($data['end_date'])) {
            $start_date = $data['start_date'];
            $end_date = $data['end_date'];
            $query .= " AND DATE(created_at) BETWEEN DATE(?) AND DATE(?)";
            $countQuery.= " AND DATE(created_at) BETWEEN DATE(?) AND DATE(?)";
            $params[] = $start_date;
            $params[] = $end_date;
            
        }

        if (isset($_GET['user_id'])) {
            $user_id = $_GET['user_id'];
            $query .= " AND enquiries.id IN (SELECT enquiry_id FROM assign_enquiries WHERE user_id = $user_id AND status = 1)";
            $countQuery.= " AND enquiries.id IN (SELECT enquiry_id FROM assign_enquiries WHERE user_id = $user_id AND status = 1)";
        }


        $query .= " ORDER BY enquiries.created_at ASC";
        $query .= " LIMIT $limit OFFSET $offset";
        // Prepare and execute the statement
        $stmt = $conn->prepare($query);
        $stmt->execute($params);


        $count_query_stmt = $conn->prepare($countQuery);
        $count_query_stmt->execute($params);
        // Fetch all records
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $countQueryResult = $count_query_stmt->fetch(PDO::FETCH_ASSOC);
        // Fetch field mappings with status 1
        $totalCount = isset($countQueryResult['total_count']) ? (int)$countQueryResult['total_count'] : 0;
        $totalPages = ($totalCount > 0) ? ceil($totalCount / $limit) : 1;
        $fieldStmt = $conn->prepare("SELECT field_name, title FROM enquiry_fields WHERE status = 1");
        $fieldStmt->execute();
        $fields = $fieldStmt->fetchAll(PDO::FETCH_ASSOC);
        error_log("Total Count: $totalCount, Current Page: $page, Offset: $offset, Limit: $limit");

        // Create a mapping of field names to titles
        $fieldMapping = [];
        foreach ($fields as $field) {
            $fieldMapping[$field['field_name']] = $field['title'];
        }

        // Define the required IDs
        $requiredIDs = ['office_name', 'cat_one_name', 'cat_two_name', 'cat_three_name', 'cat_four_name'];
        $sr_no = $offset + 1;
        $responseData = [];
        
        foreach ($results as $result) {
            
            $dataWithTitles = [];
            $processedKeys = [];

            foreach ($result as $key => $value) {
                // Include the required IDs explicitly
                if (isset($fieldMapping[$key]) || in_array($key, $requiredIDs)) {
                    $title = isset($fieldMapping[$key]) ? $fieldMapping[$key] : ucfirst(str_replace('_', ' ', $key));
                    
                    $dataWithTitles[] = [
                        "field_name" => $key,
                        "title" => $title,
                        "value" => $value
                    ];
                    $processedKeys[] = $key;
                }
            }
            // Ensure all required IDs are included even if they are null
            foreach ($requiredIDs as $requiredID) {
                if (!in_array($requiredID, $processedKeys)) {
                    $dataWithTitles[] = [
                        "field_name" => $requiredID,
                        "title" => ucfirst(str_replace('_', ' ', $requiredID)),
                        "value" => null
                    ];
                }
            }

            // Fetch products related to the enquiry if ID is provided
            $products = [];
            if (isset($result['id'])) {
                $pStmt = $conn->prepare("SELECT * FROM enquiry_products ep INNER JOIN products p ON ep.product_id = p.id WHERE ep.enquiry_id = :enquiry_id");
                $pStmt->execute([':enquiry_id' => $result['id']]);
                $products = $pStmt->fetchAll(PDO::FETCH_ASSOC);
            }
            
            
            
            $responseData[] = [
                "sr_no" => $sr_no++,
                "id" => $result['id'],
                "fields" => $dataWithTitles,
                "products" => $products
            ];
        }

        $response = [
            "success" => true,
            "data" => $responseData,

            "pagination" => [
                    "current_page" => $page,
                   "per_page" => $limit,
                    "total_entries" => $totalCount,
                    "total_pages" => $totalPages
                ]
        ];
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => "method not allowed"
    ]);
}
