<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Get JSON input data
        $data = json_decode(file_get_contents("php://input"), true);

        // Check if id and status are set
        if (isset($data['id']) && isset($data['status'])) {
            $id = $data['id'];
            $status = $data['status'];

            // Prepare SQL query with placeholders to prevent SQL injection

            $STATUS_SQL = $conn->prepare("SELECT * FROM config_lead_stages WHERE matured_status");
            $STATUS_SQL->execute();
            $maturedStatuses = $STATUS_SQL->fetch(PDO::FETCH_ASSOC);


            if ($status == $maturedStatuses['title']) {
                $sql = "UPDATE enquiries SET enquiry_status_steps = :status, enquiry_matured_date = NOW() WHERE id = :id";
            } else {
                $sql = "UPDATE enquiries SET enquiry_status_steps = :status WHERE id = :id";
            }
            $stmt = $conn->prepare($sql);
            // Bind parameters
            $stmt->bindParam(':status', $status);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "Record updated successfully"
                ];
            } else {
                throw new Exception("Failed to update the record");
            }
        } else {
            throw new Exception("ID and status are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    // Return JSON response
    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
