<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

        // Initialize the SQL query
        $sql = "SELECT 
                SUM(fu.price_offered) AS total_sale, 
                u.full_name, 
                DATE_FORMAT(fu.followup_date, '%M') AS month_name
            FROM 
                follow_up fu
            INNER JOIN 
                assign_enquiries ae ON fu.enquiry_id = ae.enquiry_id
            INNER JOIN 
                users u ON ae.user_id = u.id
            INNER JOIN 
                enquiries e ON fu.enquiry_id = e.id
            INNER JOIN 
                config_lead_stages cls ON e.status COLLATE utf8mb4_general_ci = cls.title COLLATE utf8mb4_general_ci
            WHERE 
                cls.matured_status = 1
                AND ae.status = 1 ";
        
        // Add user_id condition if provided
        if ($user_id) {
            $sql .= "AND u.id = :uid ";
        }
        $sql .= " GROUP BY u.id, DATE_FORMAT(fu.followup_date, '%M')";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters if user_id is provided
        if ($user_id) {
            $stmt->bindParam(':uid', $user_id, PDO::PARAM_INT);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($organizations) > 0) {
            $response = [
                "success" => true,
                "data" => $organizations
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
