<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $sql = "SELECT * FROM users";
        // $sql = "SELECT * FROM users WHERE id IN (SELECT user_id from follow_up)";
        $params = [];

        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $agents = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($agents) > 0) {
            $response = [
                 "success" => true,
                "data" => $agents
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
