<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    try {
        // Check for required fields
        if (empty($_POST['id'])) {
            throw new Exception("Missing enquiry ID");
        }

        $enquiry_id = $_POST['id'];

        // Define upload directory
        $uploadDir = '../../../Uploads/';
        if (!is_dir($uploadDir)) {
            throw new Exception("Upload directory does not exist.");
        }

        // Prepare the database statement
        $imageStmt = $conn->prepare("
            INSERT INTO enquiry_images (image_path, enquiry_id, title) 
            VALUES (:image_path, :enquiry_id, :title)
        ");

        // Process uploaded files
        foreach ($_FILES as $key => $file) {
                $imageName = $_POST["title"] ?? null;

                $tmpName = $file['tmp_name'];
                $fileName = uniqid() . "_" . basename($file['name']);
                $imagePath = $uploadDir . $fileName;

                // Move the uploaded file
                if (move_uploaded_file($tmpName, $imagePath)) {
                    // Bind and execute the query
                    $imageStmt->bindParam(':image_path', $fileName);
                    $imageStmt->bindParam(':enquiry_id', $enquiry_id);
                    $imageStmt->bindParam(':title', $imageName);
                    $imageStmt->execute();
                } else {
                    throw new Exception("Failed to upload image: {$file['name']}");
                }
            
        }

        // Successful response
        $response = [
            "success" => true,
            "message" => "Images saved successfully."
        ];
    } catch (Exception $e) {
        // Error response
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
    exit;
}
