<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['id'])) {
            $id = $data['id'];

            // Prepare SQL and bind parameters
            $stmt = $conn->prepare("DELETE FROM enquiries WHERE id = :id");
            $stmt->bindValue(':id', $id);
            $stmt->execute();

            $stmt = $conn->prepare("DELETE FROM assign_enquiries WHERE enquiry_id = :id");
            $stmt->bindValue(':id', $id);

            // Execute the statement
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "Record deleted successfully"
                ];
            } else {
                throw new Exception("Error executing query.");
            }
        } else {
            throw new Exception("ID is required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
