<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Initialize user ID query fragment
        $user_id_query = "";

        // Add user_id condition if provided
        if (isset($_GET['user_id'])) {
            $user_id_query = "enquiries.id IN (
                SELECT enquiry_id 
                FROM assign_enquiries 
                WHERE status = 1 AND user_id = :user_id
            )";
        }

        // Base query
        $query = "SELECT 
                        enquiries.*, 
                        office.name AS office_name, 
                        category_level_one.name AS cat_one_name, 
                        category_level_two.name AS cat_two_name, 
                        category_level_three.name AS cat_three_name, 
                        category_level_four.name AS cat_four_name 
                  FROM enquiries 
                  LEFT JOIN office ON enquiries.office_id = office.id
                  LEFT JOIN category_level_one ON enquiries.cat_one_id = category_level_one.id
                  LEFT JOIN category_level_two ON enquiries.cat_two_id = category_level_two.id
                  LEFT JOIN category_level_three ON enquiries.cat_three_id = category_level_three.id
                  LEFT JOIN category_level_four ON enquiries.cat_four_id = category_level_four.id
                  WHERE ("; // Start WHERE condition

        // Add conditions dynamically
        $conditions = [];
        if (!empty($user_id_query)) {
            $conditions[] = $user_id_query;
        }
        $conditions[] = "enquiries.id IN (
                            SELECT enquiry_id 
                            FROM follow_up 
                            WHERE called_status = 'Lead Matured'
                         )";
        $conditions[] = "enquiries.matured = 1";
        $conditions[] = "enquiry_status_steps IN (select title from config_lead_stages WHERE matured_status = 1)";

        // Combine conditions with OR
        $query .= implode(" OR ", $conditions) . ")";

        // Add date range filter if provided
        if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
            $query .= " AND DATE(created_at) BETWEEN DATE(:start_date) AND DATE(:end_date)";
        }
        

        $params = [];

        // Add user_id to parameters if provided
        if (isset($_GET['user_id'])) {
            $params[':user_id'] = $_GET['user_id'];
        }
        // Add date range parameters if provided
        if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
            $params[':start_date'] = $_GET['start_date'];
            $params[':end_date'] = $_GET['end_date'];
        }

        // Prepare and execute the statement
        $stmt = $conn->prepare($query);
        $stmt->execute($params);

        // Fetch all records
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Fetch field mappings with status 1
        $fieldStmt = $conn->prepare("SELECT field_name, title FROM enquiry_fields WHERE status = 1");
        $fieldStmt->execute();
        $fields = $fieldStmt->fetchAll(PDO::FETCH_ASSOC);

        // Create a mapping of field names to titles
        $fieldMapping = [];
        foreach ($fields as $field) {
            $fieldMapping[$field['field_name']] = $field['title'];
        }

        // Define the required IDs
        $requiredIDs = ['office_name', 'cat_one_name', 'cat_two_name', 'cat_three_name', 'cat_four_name'];

        $responseData = [];
        foreach ($results as $result) {
            $dataWithTitles = [];
            foreach ($result as $key => $value) {
                // Include the required IDs explicitly
                if (isset($fieldMapping[$key]) || in_array($key, $requiredIDs)) {
                    $title = isset($fieldMapping[$key]) ? $fieldMapping[$key] : ucfirst(str_replace('_', ' ', $key));
                    $dataWithTitles[] = [
                        "field_name" => $key,
                        "title" => $title,
                        "value" => $value
                    ];
                }
            }
            // Ensure all required IDs are included even if they are null
            foreach ($requiredIDs as $requiredID) {
                if (!isset($result[$requiredID])) {
                    $dataWithTitles[] = [
                        "field_name" => $requiredID,
                        "title" => ucfirst(str_replace('_', ' ', $requiredID)),
                        "value" => null
                    ];
                }
            }
            $responseData[] = [
                "id" => $result['id'],
                "fields" => $dataWithTitles
            ];
        }

        $response = [
            "success" => true,
            "data" => $responseData
        ];
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred.",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage(),
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}
?>
