<?php
header('Content-Type: application/json'); // Set header for JSON response
include '../../config.php';

function convertUTCtoMySQL($utcDateString)
{
    if (empty($utcDateString)) {
        return null;
    }
    try {
        $date = new DateTime($utcDateString, new DateTimeZone('UTC'));
        $date->setTimezone(new DateTimeZone('UTC')); // Change if needed
        return $date->format('Y-m-d H:i:s');
    } catch (Exception $e) {
        throw new Exception("Invalid date format provided: " . $e->getMessage());
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        // Mandatory field validation
        if (empty($data['user_id']) || empty($data['enquiry_id']) || empty($data['followup_date'])) {
            throw new Exception("All mandatory fields (user_id, enquiry_id, followup_date) are required.");
        }

        // Assign variables
        $user_id = $data['user_id'];
        $enquiry_id = $data['enquiry_id'];
        $called_by = $data['called_by'] ?? '';
        $follow_up_type = $data['follow_up_type'] ?? '';
        $follow_up_status = $data['follow_up_status'] ?? '';
        $next_follow_up_type = $data['next_follow_up_type'] ?? '';
        $called_type = $data['called_type'] ?? 0;
        $followup_date = $data['followup_date'];
        $remarks = $data['remarks'] ?? null;
        $call_type = $data['call_type'] ?? null;
        $price_offered = $data['price_offered'] ?? null;
        $meeting_conducted = $data['meeting_conducted'] ?? null;
        $location = $data['location'] ?? null;
        $called_status = $data['called_status'] ?? null;
        $dialer_start_time = convertUTCtoMySQL($data['dialer_start_time'] ?? null);
        $dialer_end_time = convertUTCtoMySQL($data['dialer_end_time'] ?? null);
        $next_followup_date = isset($data['next_followup_date']) ? $data['next_followup_date'] : null;
        $dial_end_time = isset($data['dialer_end_time']) ? convertUTCtoMySQL($data['dialer_end_time']) : null;
        $dial_start_time = isset($data['dialer_start_time']) ? convertUTCtoMySQL($data['dialer_start_time']) : null;

        $conn->beginTransaction(); // Begin transaction

        // Prevent follow-up before next follow-up date
        $prevCheckSql = "SELECT * FROM follow_up WHERE DATE('$followup_date') < DATE(next_followup_date) AND enquiry_id = $enquiry_id";
        $prevCheckStmt = $conn->prepare($prevCheckSql);
        $prevCheckStmt->execute();

        // Check if any rows were returned
        $rowCount = $prevCheckStmt->rowCount();
        if ($rowCount > 0) {
            throw new Exception("Cannot enter a follow-up before the next follow-up date.");
        }


        // Insert follow-up record
        $sql = "INSERT INTO follow_up (
                user_id, enquiry_id, called_by, follow_up_type, follow_up_status, 
                next_follow_up_type, followup_date, remarks, price_offered, next_followup_date, 
                location, dial_start_time, dial_end_time, call_type, meeting_conducted, called_type, called_status
                ) VALUES (
                    :user_id, :enquiry_id, :called_by, :follow_up_type, :follow_up_status, 
                    :next_follow_up_type, DATE(:followup_date), :remarks, :price_offered, DATE(:next_followup_date), 
                    :location, :dial_start_time, :dial_end_time, :call_type, :meeting_conducted, :called_type, :called_status
                )";

        $stmt = $conn->prepare($sql);
        $stmt->execute([
            ':user_id' => $user_id,
            ':enquiry_id' => $enquiry_id,
            ':called_status' => $called_status,
            ':called_by' => $called_by,
            ':called_type' => $called_type,
            ':follow_up_type' => $follow_up_type,
            ':follow_up_status' => $follow_up_status,
            ':next_follow_up_type' => $next_follow_up_type,
            ':followup_date' => $followup_date,
            ':remarks' => $remarks,
            ':price_offered' => $price_offered,
            ':next_followup_date' => $next_followup_date,
            ':location' => $location, // Correct placeholder name for 'location'
            ':dial_start_time' => $dial_start_time, // Correct placeholder name for 'dial_start_time'
            ':dial_end_time' => $dial_end_time, // Correct placeholder name for 'dial_end_time'
            ':call_type' => $call_type,
            ':meeting_conducted' => $meeting_conducted
        ]);


        $lastInsertId = $conn->lastInsertId();

        // Insert follow-up products if provided
        if (!empty($data['product']) && is_array($data['product'])) {
            $sql2 = "INSERT INTO follow_up_products (follow_up_id, product_id) VALUES (:follow_up_id, :product_id)";
            $stmt2 = $conn->prepare($sql2);
            foreach ($data['product'] as $product_id) {
                $stmt2->execute([
                    ':follow_up_id' => $lastInsertId,
                    ':product_id' => $product_id
                ]);
            }
        }

        // Update enquiries table
        $updateEnquirySql = "UPDATE enquiries SET status = :called_status WHERE id = :enquiry_id";
        $updateStmt = $conn->prepare($updateEnquirySql);
        $updateStmt->execute([
            ':called_status' => $called_status,
            ':enquiry_id' => $enquiry_id
        ]);

        // Update enquiry status steps for specific statuses
        if (in_array($called_status, ['Lead Matured', 'Dropped'])) {
            if ($called_status == 'Dropped') {
                $updateStatusStepsSql = "UPDATE enquiries SET enquiry_status_steps = :called_status WHERE id = :enquiry_id";
            } else {
                $updateStatusStepsSql = "UPDATE enquiries SET enquiry_status_steps = :called_status, enquiry_matured_date = NOW() WHERE id = :enquiry_id";
            }
            $updateStatusStmt = $conn->prepare($updateStatusStepsSql);
            $updateStatusStmt->execute([
                ':called_status' => $called_status,
                ':enquiry_id' => $enquiry_id
            ]);
        }

        $conn->commit(); // Commit transaction

        // Success response
        echo json_encode([
            "success" => true,
            "message" => "New record created successfully."
        ]);
    } catch (PDOException $e) {
        $conn->rollBack(); // Rollback transaction on error
        echo json_encode([
            "success" => false,
            "message" => "Database error occurred.",
            "error_details" => $e->getMessage()
        ]);
    } catch (Exception $e) {
        echo json_encode([
            "success" => false,
            "message" => $e->getMessage(),
            "error_details" => $e->getMessage()
        ]);
    }
} else {
    // Invalid request method response
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}
