<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $data = [];
        // Prepare SQL query
        $sql = "SELECT * FROM config_kpis_role WHERE role_id = $_GET[role_id] AND kpi_id = $_GET[kpi_id]";
        $stmt = $conn->prepare($sql);

        // Execute the query
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($result as $key => $value) {
                $sql_table = "SELECT * FROM config_kpis_role_table WHERE kpi_role_id = :kpi_role_id";
                $stmt_table = $conn->prepare($sql_table);
                $stmt_table->bindParam(':kpi_role_id', $value['id'], PDO::PARAM_INT);
                $stmt_table->execute();
                $table_data = $stmt_table->fetchAll(PDO::FETCH_ASSOC);
                $value['table'] = $table_data;
                $data[] = $value;
            }

            $response = [
                "success" => true,
                "data" => $data
            ];
        } else {
            throw new Exception("Failed to retrieve records");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
?>
