<?php

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    try {
        // Get the data from the PUT request
        $data = json_decode(file_get_contents("php://input"), true);

        // Check if data is received correctly
        if ($data === null) {
            throw new Exception("Invalid JSON data received");
        }

        // Ensure the 'name' and 'id' fields are provided for identifying the record
        if (!isset($data['name']) || !isset($data['id'])) {
            throw new Exception("Name or ID missing");
        }

        $name = $data['name'];
        $id = $data['id'];
        $quot_inactive_days = $data['quot_inactive_days'];
        $sender_email = isset($data['sender_email']) ? $data['sender_email'] : null;
        $password = isset($data['password']) ? $data['password'] : null;
        $port = isset($data['port']) ? $data['port'] : null;
        $host = isset($data['host']) ? $data['host'] : null;

        // Prepare the SQL query with placeholders
        $sql = "UPDATE office SET name = :name, quot_inactive_days = $quot_inactive_days";

        // Add optional fields to the query if they are provided
        if ($sender_email !== null) $sql .= ", sender_email = :sender_email";
        if ($password !== null) $sql .= ", password = :password";
        if ($port !== null) $sql .= ", port = :port";
        if ($host !== null) $sql .= ", host = :host";

        $sql .= " WHERE id = :id";

        // Prepare the statement
        $stmt = $conn->prepare($sql);

        // Bind the parameters
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':id', $id);
        if ($sender_email !== null) $stmt->bindParam(':sender_email', $sender_email);
        if ($password !== null) $stmt->bindParam(':password', $password);
        if ($port !== null) $stmt->bindParam(':port', $port);
        if ($host !== null) $stmt->bindParam(':host', $host);

        // Execute the statement
        if ($stmt->execute()) {
            $response = [
                "success" => true,
                "message" => "Record updated successfully"
            ];
        } else {
            throw new Exception("No record updated");
        }
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
