<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {
        // Check if the ID is set in the query parameters
        if (isset($_GET['id'])) {
            $id = $_GET['id'];

            // Prepare SQL query
            $sql = "DELETE FROM products WHERE id = :id";
            $stmt = $conn->prepare($sql);

            // Bind parameter
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "Record deleted successfully"
                ];
            } else {
                throw new Exception("Failed to delete record");
            }
        } else {
            throw new Exception("ID is required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
