<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $data = [];

        // Prepare SQL query for products
        $sql = "SELECT quotations.*, enquiries.enquiry_entered_by, enquiries.mobile_no_one FROM quotations INNER JOIN enquiries ON quotations.enquiry_id = enquiries.id WHERE is_sales_order = 1";

        if(isset($_GET['id'])){
            $sql .= " AND id = ".$_GET['id'];
        }

        if (isset($_GET['user_id'])) {
            $sql .= " AND enquiry_id IN (SELECT enquiry_id FROM assign_enquiries WHERE user_id = $_GET[user_id])";
        }


        $stmt = $conn->prepare($sql);

        // Execute the query
        if ($stmt->execute()) {
            $products = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Iterate over each product to fetch associated service charges
            foreach ($products as &$product) {
                $sql_service = "SELECT qi.service_units, qi.quantity as quantity, p.product_name , p.type_of_product, psc.range_end, p.type_of_product, p.price, psc.range_start, psc.unit, psc.unit_price , p.id as main_product_id, qi.service_category as main_service_id, qi.id as quot_item_id
                                FROM quotations_items qi 
                                INNER JOIN products p ON qi.product_id = p.id
                                LEFT JOIN product_service_charges psc ON psc.id = qi.service_category 
                                WHERE qi.quotations_id = :product_id";
                $service_stmt = $conn->prepare($sql_service);
                $service_stmt->execute(['product_id' => $product['id']]);
                $product['products'] = $service_stmt->fetchAll(PDO::FETCH_ASSOC);
            }

            foreach ($products as &$product) {
                $sql_service = "SELECT p.product_name, psc.range_start, psc.range_end, psc.unit, qi.service_units, (((qi.service_units - (psc.range_start - 1)) * psc.unit_price) + psc.additional_amount + p.price) as total_amount FROM quotations_items qi 
                                INNER JOIN products p ON qi.product_id = p.id
                                INNER JOIN product_service_charges psc ON qi.service_units BETWEEN psc.range_start AND psc.range_end AND psc.product_id = qi.product_id
                                WHERE qi.quotations_id = :product_id AND p.type_of_product = 'Service'";
                $service_stmt = $conn->prepare($sql_service);
                $service_stmt->execute(['product_id' => $product['id']]);
                $product['service'] = $service_stmt->fetchAll(PDO::FETCH_ASSOC);
            }

            $data = $products;

            $response = [
                "success" => true,
                "data" => $data
            ];
        } else {
            throw new Exception("Failed to retrieve records");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
