<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['role'])) {
            $role = $data['role'];
            $self_inquiries = $data['self_inquiries'] ?? 0;

            // Prepare SQL and bind parameters
            $stmt = $conn->prepare("INSERT INTO roles (role, self_inquiries) VALUES (:role, :self_inquiries)");
            $stmt->bindParam(':role', $role);
            $stmt->bindParam(':self_inquiries', $self_inquiries, PDO::PARAM_BOOL);

            // Execute the statement
            $stmt->execute();

            $response = [
                "success" => true,
                "message" => "New record created successfully"
            ];
        } else {
            throw new Exception("Role and Self Inquiries are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
