<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

        // Initialize the SQL query
        $sql = "SELECT count(DISTINCT eq.id) as total, eq.enquiry_status_steps, u.username 
                    FROM enquiries eq
                    INNER JOIN assign_enquiries aq ON eq.id = aq.enquiry_id
                    INNER JOIN users u ON aq.user_id = u.id 
                    WHERE aq.status = 1 ";

        // Add user_id condition if provided
        if ($user_id) {
            $sql .= " AND aq.user_id= :uid ";
        }
        
        $sql .= "GROUP BY enquiry_status_steps, u.username";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters if user_id is provided
        if ($user_id) {
            $stmt->bindParam(':uid', $user_id, PDO::PARAM_INT);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($organizations) > 0) {
            $response = [
                "success" => true,
                "data" => $organizations
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
