<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Validate required parameters
        if (!isset($_GET['user_id']) || !isset($_GET['start_date']) || !isset($_GET['end_date'])) {
            throw new Exception("Missing required parameters: user_id, start_date, or end_date.");
        }

        $user_id = $_GET['user_id'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];

        // First query: Done follow-ups
        $sql = "SELECT COUNT(*) as total 
            FROM follow_up fu
            INNER JOIN assign_enquiries aq ON aq.enquiry_id = fu.enquiry_id
            WHERE fu.followup_date BETWEEN DATE(:start_date) AND DATE(:end_date)
              AND aq.user_id = :user_id
              AND fu.called_status = 'Follow-up Required'
              AND DATE(fu.followup_date) IN (
                  SELECT DATE(next_followup_date) 
                  FROM follow_up 
                  WHERE enquiry_id = fu.enquiry_id
              );
        ";
        $stmt = $conn->prepare($sql);
        $stmt->execute([
            ':start_date' => $start_date,
            ':end_date' => $end_date,
            ':user_id' => $user_id,
        ]);
        $kpis = $stmt->fetch(PDO::FETCH_ASSOC);

        // Second query: Total follow-ups
        $sql_two = "
            SELECT COUNT(*) as total 
            FROM follow_up fu
            INNER JOIN assign_enquiries aq ON aq.enquiry_id = fu.enquiry_id
            WHERE fu.followup_date BETWEEN DATE(:start_date) AND DATE(:end_date)
            AND fu.called_status = 'Follow-up Required'
              AND aq.user_id = :user_id;
        ";
        $stmt_sql_two = $conn->prepare($sql_two);
        $stmt_sql_two->execute([
            ':start_date' => $start_date,
            ':end_date' => $end_date,
            ':user_id' => $user_id,
        ]);
        $stmt_sql_two_data = $stmt_sql_two->fetch(PDO::FETCH_ASSOC);

        // Construct response
        if ($kpis && $stmt_sql_two_data) {
            $response = [
                "success" => true,
                "data" => [
                    'done_followup' => (int)$kpis['total'],
                    'notdone_followup' => (int)$stmt_sql_two_data['total'],
                ],
            ];
        } else {
            throw new Exception("No data found.");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred.",
            "error_details" => $e->getMessage(),
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage(),
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method. Only GET is allowed.",
    ]);
}
