<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {

        if (!isset($_GET['user_id']) || !isset($_GET['start_date']) || !isset($_GET['end_date'])) {
            throw new Exception("Missing required parameters: user_id, start_date, or end_date.");
        }

        $user_id = $_GET['user_id'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];

        $sql = "SELECT 
                    SUM(CASE WHEN is_sales_order = 1 THEN 1 ELSE 0 END) AS sales_order_count,
                    COUNT(*) AS total_entries
                FROM quotations
                INNER JOIN assign_enquiries ae ON ae.enquiry_id =  quotations.enquiry_id
                WHERE DATE(dated) BETWEEN DATE('$start_date') AND DATE('$end_date') AND ae.user_id = $user_id AND ae.status = 1;";


        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $kpis = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($kpis) > 0) {
            $response = [
                 "success" => true,
                "data" => $kpis
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
