<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {

        if (!isset($_GET['user_id']) && !isset($_GET['start_date']) && !isset($_GET['end_date'])) {
            throw new Exception("Params missing");
        }

        $user_id = $_GET['user_id'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];


        $sql = "SELECT 
            DISTINCT eq.id , 
            eq.created_at, 
            eq.enquiry_matured_date, 
            DATEDIFF(enquiry_matured_date, created_at) as date_diff 
        FROM enquiries eq
        INNER JOIN assign_enquiries aq ON eq.id = aq.enquiry_id
        WHERE DATE(eq.created_at) BETWEEN DATE('$start_date') AND DATE('$end_date') 
        AND aq.user_id = $user_id AND aq.status = 1;";

        $sqlCount = "SELECT 
            COUNT(eq.id) AS total, 
            SUM(CASE WHEN eq.enquiry_matured_date IS NOT NULL THEN 1 ELSE 0 END) AS matured
        FROM enquiries eq
        INNER JOIN assign_enquiries aq ON eq.id = aq.enquiry_id
        WHERE DATE(eq.created_at) BETWEEN DATE('$start_date') AND DATE('$end_date') 
        AND aq.user_id = $user_id AND aq.status = 1;";


        $sqlCount = $conn->prepare($sqlCount);
        $stmt = $conn->prepare($sql);
        $sqlCount->execute();
        $stmt->execute();
        $sqlCount = $sqlCount->fetch(PDO::FETCH_ASSOC);
        $kpis = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($kpis) > 0) {
            $response = [
                "success" => true,
                "data" => $kpis,
                "count" => $sqlCount
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "No data found",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
