<?php
header('Content-Type: application/json');
include '../../../config.php'; // Include the config file

try {
    // Get the input data
    $input = file_get_contents("php://input");
    $data = json_decode($input, true);

    if (!is_array($data)) {
        throw new Exception('Invalid data format');
    }

    // Iterate over the data
    foreach ($data as $key => $item) {
        if (!isset($item['title']) || !isset($item['status']) || !isset($item['type']) || !isset($item['order_no'])) {
            throw new Exception('Title, status, type, or order number missing');
        }

        // Extract field values
        $title = htmlspecialchars($item['title'], ENT_QUOTES, 'UTF-8');
        $status = filter_var($item['status'], FILTER_VALIDATE_BOOLEAN) ? 1 : 0;
        $type = htmlspecialchars($item['type'], ENT_QUOTES, 'UTF-8');
        $show = filter_var($item['show'], FILTER_VALIDATE_BOOLEAN) ? 1 : 0;
        $report_show = filter_var($item['report_show'], FILTER_VALIDATE_BOOLEAN) ? 1 : 0;
        $required = filter_var($item['required'], FILTER_VALIDATE_BOOLEAN) ? 1 : 0;
        $searchcheckbox = filter_var($item['searchcheckbox'], FILTER_VALIDATE_BOOLEAN) ? 1 : 0;
        $order_no = (int)$item['order_no'];
        $field_name = htmlspecialchars($key, ENT_QUOTES, 'UTF-8');

        // Process the item: Update fields including `searchcheckbox`
        $stmt = $conn->prepare(
            "UPDATE enquiry_fields 
            SET status = :status, 
                title = :title, 
                type = :type, 
                show_field = :show, 
                report_show = :report_show, 
                order_no = :order_no, 
                required = :required,
                searchcheckbox = :searchcheckbox
            WHERE field_name = :field_name"
        );

        $stmt->execute([
            ':status' => $status,
            ':title' => $title,
            ':type' => $type,
            ':field_name' => $field_name,
            ':show' => $show,
            ':report_show' => $report_show,
            ':required' => $required,
            ':searchcheckbox' => $searchcheckbox,
            ':order_no' => $order_no
        ]);
    }

    echo json_encode(['success' => true, 'message' => 'Fields updated successfully']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    exit;
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    exit;
}
?>
