<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['enquiry_id'], $data['user_id'], $data['json_data'])) {
            $isEdit = $data['edit'] ?? false;
            $enquiry_id = $data['enquiry_id'];
            $user_id = $data['user_id'];
            $json_data = json_encode($data['json_data'], JSON_UNESCAPED_UNICODE); // Store JSON data properly
            $quotation_type = $data['quotation_type']?? null;


            $DELETE_SQL = "DELETE from quotations WHERE enquiry_id = $enquiry_id";
            $DELETE_SQL = $conn->prepare($DELETE_SQL);
            $DELETE_SQL->execute();

            if (!$isEdit) {
                // Insert new quotation
                $sql = "INSERT INTO quotations (enquiry_id, user_id, json_data, quotation_type, dated) 
                        VALUES (:enquiry_id, :user_id, :json_data, :quotation_type, NOW())";
                $stmt = $conn->prepare($sql);
                $stmt->bindParam(':enquiry_id', $enquiry_id);
                $stmt->bindParam(':user_id', $user_id);
                $stmt->bindParam(':json_data', $json_data);
                $stmt->bindParam(':quotation_type', $quotation_type);

                if ($stmt->execute()) {
                    $quot_id = $conn->lastInsertId();

                    $response = [
                        "success" => true,
                        "message" => "New record created successfully",
                        "quotation_id" => $quot_id
                    ];
                } else {
                    throw new Exception("Failed to insert quotation");
                }
            } else {
                // Update existing quotation
                $quotation_id = $data['quotation_id'];

                $sql = "UPDATE quotations 
                        SET json_data = :json_data, quotation_type = :quotation_type
                        WHERE id = :quotation_id";
                $stmt = $conn->prepare($sql);
                $stmt->bindParam(':quotation_id', $quotation_id);
                $stmt->bindParam(':json_data', $json_data);
                $stmt->bindParam(':quotation_type', $quotation_type);

                if ($stmt->execute()) {
                    $response = [
                        "success" => true,
                        "message" => "Record updated successfully"
                    ];
                } else {
                    throw new Exception("Failed to update record");
                }
            }
        } else {
            throw new Exception("Missing required fields in the request payload");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
