<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (
            isset($data['username']) &&
            isset($data['password']) &&
            isset($data['role_id'])
        ) {
            $username = $data['username'];
            $full_name = $data['full_name'];
            $password = password_hash($data['password'], PASSWORD_BCRYPT); // Hash the password
            $email = $data['email'];
            $role_id = $data['role_id'];
            $office_id = $data['office_id'];
            $cnic = $data['cnic'] ?? null;
            $mobile_no = $data['mobile_no'] ?? null;
            $landline = $data['landline'] ?? null;

            // Check if email already exists
            $checkEmailSql = "SELECT COUNT(*) FROM users WHERE username = :username";
            $stmt = $conn->prepare($checkEmailSql);
            $stmt->bindParam(':username', $username);
            $stmt->execute();
            $emailExists = $stmt->fetchColumn();

            if ($emailExists > 0) {
                throw new Exception("User is inactive, please make it Active.");
            }

            // Prepare SQL query
            $sql = "INSERT INTO users (username, full_name, password, email, role_id, office_id, cnic, mobile_no, landline) 
                    VALUES (:username, :full_name, :password, :email, :role_id, :office_id, :cnic, :mobile_no, :landline)";

            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':username', $username);
            $stmt->bindParam(':full_name', $full_name);
            $stmt->bindParam(':password', $password);
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':role_id', $role_id);
            $stmt->bindParam(':office_id', $office_id);
            $stmt->bindParam(':cnic', $cnic);
            $stmt->bindParam(':mobile_no', $mobile_no);
            $stmt->bindParam(':landline', $landline);

            // Execute the query
            if ($stmt->execute()) {
                $response = [
                    "success" => true,
                    "message" => "New record created successfully"
                ];
            } else {
                throw new Exception("Failed to insert record");
            }
        } else {
            throw new Exception("All fields are required");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
