<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Validate the presence of enquiry_id parameter
        if (!isset($_GET['enquiry_id'])) {
            throw new Exception('enquiry_id is required');
        }
        $enquiry_id = $_GET['enquiry_id'];

        // Prepare SQL query
        $sql = "SELECT products.* FROM products INNER JOIN enquiry_products ON products.id = enquiry_products.product_id WHERE enquiry_id = :enquiry_id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':enquiry_id', $enquiry_id, PDO::PARAM_INT);

        // Execute the query
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

            $response = [
                "success" => true,
                "data" => $result
            ];
        } else {
            throw new Exception("Failed to retrieve records");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
