<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Function to send mail
function sendMail($email_to, $subject, $Body_of_Email, $user_id) {
    try {
        
        $sql = "SELECT o.* FROM users u INNER JOIN office o ON u.office_id = o.id WHERE u.id = :user_id LIMIT 1";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        
        if ($stmt->execute()) {
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
        } else {
            throw new Exception("Failed to retrieve records");
        }
        
        $Sender_Email = "$result[sender_email]";

        $headers = "From: SmartCRM <$Sender_Email>\r\n";
        $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
        $message = $Body_of_Email;
        
        require_once 'PHPmailer/src/Exception.php';
        require_once 'PHPmailer/src/PHPMailer.php';
        require_once 'PHPmailer/src/SMTP.php';

        $mail = new PHPMailer(true);

        // Set SMTPDebug to 0 to disable logging
        $mail->SMTPDebug = 0;                     
        $mail->isSMTP();                                            
        $mail->Host       = "$result[host]";                    
        $mail->SMTPAuth   = true;                                   
        $mail->Username   = "$result[sender_email]";                     
        $mail->Password   = "$result[password]";                               
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;         
        $mail->Port       = 465;                                   

        $mail->setFrom("$result[sender_email]", 'SmartCMS');
        $mail->addAddress($email_to);     

        $mail->isHTML(true);                                
        $mail->Subject = $subject;
        $mail->Body    = $Body_of_Email;

        $mail->send();
        return true;
    } catch(Exception $e) {
        return 'Message: ' . $e->getMessage();
    }
}
?>
