<?php
function getMacAddress() {
    $mac_address = 'Not Available';
    if (PHP_OS_FAMILY === 'Linux' || PHP_OS_FAMILY === 'Darwin') {
        exec("ip link show | grep -Po 'ether \K[[:xdigit:]:]+'", $output);
        $mac_address = isset($output[0]) ? $output[0] : 'Not Available';
    } elseif (PHP_OS_FAMILY === 'Windows') {
        $output = shell_exec("getmac /FO LIST /NH");
        if ($output) {
            preg_match("/([0-9A-Fa-f-]{17})/", $output, $matches);
            $mac_address = isset($matches[0]) ? str_replace('-', ':', $matches[0]) : 'Not Available';
        }
    }
    echo $mac_address;
};
getMacAddress();

?>