<?php
include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Get the data from the POST request
        $data = json_decode(file_get_contents("php://input"), true);

        // Check if 'id' is provided and valid
        if (!isset($data['id'])) {
            throw new Exception("ID is required for deletion");
        }

        $id = intval($data['id']);

        if ($id <= 0) {
            throw new Exception("Invalid ID provided");
        }

        // Initialize the SQL query
        $sql = "DELETE FROM category_level_one WHERE id = :id";

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        // Execute the SQL query
        if ($stmt->execute()) {
            $response = [
                "success" => true,
                "message" => "Record deleted successfully"
            ];
        } else {
            throw new Exception("Error deleting record");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
        "error_details" => $e->getMessage()
    ]);
}
