<?php
header('Content-Type: application/json'); // Set header for JSON response

include '../../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        $name = isset($_GET['name']) ? $_GET['name'] : null;

        // Initialize the SQL query and parameters
        $sql = "SELECT * FROM organization";
        $params = [];

        if ($id) {
            $sql .= " WHERE id = :id";
            $params[':id'] = $id;
        } elseif ($name) {
            $sql .= " WHERE name = :name";
            $params[':name'] = $name;
        }

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);

        // Bind parameters
        foreach ($params as $key => $value) {
            $stmt->bindParam($key, $value);
        }

        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($organizations) > 0) {
            // Initialize response array
            $responseData = [];

            foreach ($organizations as $organization) {
                $orgId = $organization['id'];

                // Fetch inquiries for this organization
                $enquiryStmt = $conn->prepare("SELECT * FROM config_lead_stages WHERE org_id = :org_id");
                $enquiryStmt->bindParam(':org_id', $orgId);
                $enquiryStmt->execute();

                // Fetch inquiries
                $inquiries = $enquiryStmt->fetchAll(PDO::FETCH_ASSOC);

                // Append organization and its inquiries to the response data
                $responseData[] = [
                    "organization" => $organization,
                    "inquiries" => $inquiries,
                ];
            }

            $response = [
                "success" => true,
                "data" => $responseData
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Error occurred",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
?>
