<?php
include '../../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = json_decode(file_get_contents("php://input"), true);

        if (isset($data['enquiry']) && isset($data['values'])) {
            $isEdit = $data['edit'] ?? false;
            $enquiry_id = $data['enquiry']['id'] ?? $data['enquiry'];
            $address = $data['values']['address'];
            $analysis_of = $data['values']['analysis_of'];
            $company = $data['values']['company'];
            $contact = $data['values']['contact'];
            $date = $data['values']['date'];
            $email = $data['values']['email'];
            $from = $data['values']['from'];
            $subject = $data['values']['subject'];
            $to = $data['values']['to'];
            $productSelection = $data['productSelection'];
            $serviceSelection = $data['serviceSelection'];

            if (!$isEdit) {
                // Insert new quotation
                $sql = "INSERT INTO sales_order (enquiry_id, email, contact, dated, to_person, address, subject_quot, analysis_of, sincerely_from, company_name) 
                        VALUES (:enquiry_id, :email, :contact, :dated, :to_person, :address, :subject_quot, :analysis_of, :sincerely_from, :company_name)";
                $stmt = $conn->prepare($sql);

                $stmt->bindParam(':enquiry_id', $enquiry_id);
                $stmt->bindParam(':email', $email);
                $stmt->bindParam(':contact', $contact);
                $stmt->bindParam(':dated', $date);
                $stmt->bindParam(':to_person', $to);
                $stmt->bindParam(':address', $address);
                $stmt->bindParam(':subject_quot', $subject);
                $stmt->bindParam(':analysis_of', $analysis_of);
                $stmt->bindParam(':sincerely_from', $from);
                $stmt->bindParam(':company_name', $company);

                if ($stmt->execute()) {
                    $quot_id = $conn->lastInsertId();

                    // Insert products
                    foreach ($productSelection as $p) {
                        $productSql = "INSERT INTO sales_order_items (quotations_id, product_id, quantity) 
                                       VALUES (:quotations_id, :product_id, :quantity)";
                        $productStmt = $conn->prepare($productSql);
                        $productStmt->bindParam(':quotations_id', $quot_id);
                        $productStmt->bindParam(':product_id', $p['id']);
                        $productStmt->bindParam(':quantity', $p['quantity']);
                        $productStmt->execute();
                    }

                    // Insert services
                    foreach ($serviceSelection as $s) {

                        if ($s['service_units']) {

                            $serviceSql = "INSERT INTO sales_order_items (quotations_id, product_id, service_units) 
                                       VALUES (:quotations_id, :product_id, :service_units)";
                            $serviceStmt = $conn->prepare($serviceSql);
                            $serviceStmt->bindParam(':quotations_id', $quot_id);
                            $serviceStmt->bindParam(':product_id', $s['product_id']);
                            $serviceStmt->bindParam(':service_units', $s['service_units']);
                            $serviceStmt->execute();
                        }
                    }

                    $response = [
                        "success" => true,
                        "message" => "New record created successfully"
                    ];
                } else {
                    throw new Exception("Failed to insert record");
                }
            } else {
                // Update existing quotation
                $quotation_id = $data['quotation_id'];

                $sql = "UPDATE sales_order 
                        SET email = :email, contact = :contact, dated = :dated, to_person = :to_person, 
                            address = :address, subject_quot = :subject_quot, analysis_of = :analysis_of, 
                            sincerely_from = :sincerely_from, company_name = :company_name 
                        WHERE id = :quotation_id";
                $stmt = $conn->prepare($sql);

                $stmt->bindParam(':quotation_id', $quotation_id);
                $stmt->bindParam(':email', $email);
                $stmt->bindParam(':contact', $contact);
                $stmt->bindParam(':dated', $date);
                $stmt->bindParam(':to_person', $to);
                $stmt->bindParam(':address', $address);
                $stmt->bindParam(':subject_quot', $subject);
                $stmt->bindParam(':analysis_of', $analysis_of);
                $stmt->bindParam(':sincerely_from', $from);
                $stmt->bindParam(':company_name', $company);

                $serviceDelete = "DELETE FROM sales_order_items WHERE quotations_id = $quotation_id";
                $serviceDelete = $conn->prepare($serviceDelete);
                $serviceDelete->execute();

                if ($stmt->execute()) {
                    // Update products
                    foreach ($productSelection as $p) {
                        $productSql = "INSERT INTO sales_order_items (quotations_id, product_id, quantity) 
                        VALUES (:quotations_id, :product_id, :quantity)";
                        $productStmt = $conn->prepare($productSql);
                        $productStmt->bindParam(':quotations_id', $quotation_id);
                        $productStmt->bindParam(':product_id', $p['id']);
                        $productStmt->bindParam(':quantity', $p['quantity']);
                        $productStmt->execute();
                    }

                    // Update services

                    foreach ($serviceSelection as $s) {

                        if ($s['service_units']) {
                            $serviceSql = "INSERT INTO sales_order_items (quotations_id, product_id, service_units) 
                                       VALUES (:quotations_id, :product_id, :service_units)";
                            $serviceStmt = $conn->prepare($serviceSql);
                            $serviceStmt->bindParam(':quotations_id', $quotation_id);
                            $serviceStmt->bindParam(':product_id', $s['product_id']);
                            $serviceStmt->bindParam(':service_units', $s['service_units']);
                            $serviceStmt->execute();
                        }
                    }

                    $response = [
                        "success" => true,
                        "message" => "Record updated successfully"
                    ];
                } else {
                    throw new Exception("Failed to update record");
                }
            }
        } else {
            throw new Exception("Missing fields in the request payload");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error occurred",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage(),
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
