<?php
include '../../config.php'; // Include the config file

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Fetching query parameters from the GET request
        $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

        // Initialize the SQL query
            $sql = "SELECT 
                        SUM(CASE WHEN cls.matured_status = 1 THEN 1 ELSE 0 END) AS total_sales_matured,
                        COUNT(*) AS total_enquiries
                    FROM 
                        enquiries e
                    LEFT JOIN 
                        config_lead_stages cls
                    ON 
                        e.enquiry_status_steps COLLATE utf8mb4_general_ci = cls.title COLLATE utf8mb4_general_ci
                    WHERE 
                        1 = 1";
                    ;
        
        // Add user_id condition if provided
        if ($user_id) {
            $sql .= " AND e.id IN (SELECT enquiry_id FROM assign_enquiries WHERE user_id= $user_id) ";
        }

        // Prepare the SQL statement
        $stmt = $conn->prepare($sql);
        // Execute the statement
        $stmt->execute();

        // Fetch the records as an associative array
        $organizations = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($organizations) > 0) {
            $response = [
                "success" => true,
                "data" => $organizations
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => "Field missing",
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Field missing",
            "error_details" => $e->getMessage()
    ]);
}
?>
