<?php
include '../../config.php'; // Include the config file

header('Content-Type: application/json'); // Ensure the response is JSON

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Check if user_id is set
        if (!isset($_GET['user_id']) || empty($_GET['user_id'])) {
            throw new Exception("user_id is missing");
        }

        $user_id = intval($_GET['user_id']); // Sanitize input
        $start_date = $_GET['start_date'] ?? null;
        $end_date = $_GET['end_date'] ?? null;

        // Base query
        $sql = "SELECT * FROM user_location WHERE user_id = :user_id";

        // Add date range filter if provided
        if (!empty($start_date) && !empty($end_date)) {
            $sql .= " AND DATE(at_time) BETWEEN :start_date AND :end_date";
        }

        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

        // Bind date range parameters if provided
        if (!empty($start_date) && !empty($end_date)) {
            $stmt->bindParam(':start_date', $start_date, PDO::PARAM_STR);
            $stmt->bindParam(':end_date', $end_date, PDO::PARAM_STR);
        }

        $stmt->execute();
        $agents = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($agents) > 0) {
            $response = [
                "success" => true,
                "data" => $agents
            ];
        } else {
            throw new Exception("No data found");
        }
    } catch (PDOException $e) {
        $response = [
            "success" => false,
            "message" => "Database error",
            "error_details" => $e->getMessage()
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "message" => $e->getMessage(),
            "error_details" => $e->getMessage()
        ];
    }

    echo json_encode($response);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
